/************************************************************ 
Copyright (C) 1995-2002 Pumpkin, Inc. and its
Licensor(s). Freely distributable.

$Source: C:\\RCS\\d\\salvo\\ex\\ex1\\main.h,v $
$Author: aek $
$Revision: 3.19 $
$Date: 2003-10-20 18:05:14-07 $

Header file for example programs.

************************************************************/
																
/*															*/																
/* ===================== PICmicro ========================= */
/*															*/																
#if   defined(SYSA) /* HI-TECH PICC         */ \
   || defined(SYSE) /* Microchip MPLAB-C18  */ \
   || defined(SYSF) /* HI-TECH PICC-18      */ \
   || defined(SYSH) /* HI-TECH PICC         */ \
   || defined(SYSP) /* IAR PIC18 C          */


#if   defined(SYSP)
#include <io18c452.h> /* for generic PIC18C452 */
#endif


/* setup which port to use, and initialize it */
#if   defined(SYSA) \
   || defined(SYSE) \
   || defined(SYSF) \
   || defined(SYSP)
#define PORT                        PORTB
#define InitPORT()                  do { PORTB = 0x00; \
                                         TRISB = 0x00; \
                                    } while (0) 
#elif defined(SYSH)
#define PORT                        PORTC
#define InitPORT()                  do { PORTC = 0x00; \
                                         TRISC = 0x00; \
                                    } while (0) 
#endif 


/* set TMR0 to internal clock source and enable interrupts	*/
/*  from it.												*/
#if   defined(SYSA) \
   || defined(SYSF) \
   || defined(SYSH) \
   || defined(SYSP)

/* PICC-18 uses different nomenclature */
#if defined(SYSF)	    			
#define	T0IE						TMR0IE
#define	T0IF						TMR0IF
#endif 
                      
#define	Init()						do { \
									  T0CS = 0; \
									  T0IE = 1; \
									} while (0)
											
#elif defined(SYSE) 
#define Init()						do { \
									  T0CONbits.T0CS  = 0; \
									  INTCONbits.TMR0IE = 1; \
									} while (0)
									
#endif								


/*															*/																
/* ======================= 8051 =========================== */
/*															*/																
#elif defined(SYSI) /* Keil Cx51     */ \
   || defined(SYSN) /* HI-TECH 8051C */ 
   
#if   defined(SYSI)
#include <reg51.h>  /* for generic 8051 */
#elif defined(SYSN)
#endif

/* Reload values for Timer0 - 5msec interrupts for Oscillator at 11.0592 MHz */
/* This code courtesy Michael Stepanov.                                      */
#define TIMER_H   					238 /* TH0 reload value                  */
#define TIMER_L						0   /* TL0 reload value                  */

/* we'll be outputting to port P1 */
#define PORT						P1 
#define InitPORT()					do {  P1 = 0x00; } while (0)
#define	Init()						do { TMOD =    0x21; /* TMOD:timer1-mode2 - 8-bit reload,timer0-mode1,16-bit */ \
                                         TH0  = TIMER_H; \
                                         TL0  = TIMER_L; \
                                         PT0  =       1; /* max priority for T0 interrupt */ \
                                         ET0  =       1; /* enable timer 0 interrupt */ \
                                         TR0  =       1; /* start Timer0 */ \
                                    } while (0)
                                        

/*															*/																
/* ====================== MSP430 ========================== */
/*															*/																
#elif defined(SYSQ) /* IAR MSP430 C              */ \
   || defined(SYSR) /* Archelon Quadravox AQ430  */ \
   || defined(SYSS) /* ImageCraft ICC430         */ \
   || defined(SYSX) /* Rowley CrossStudio MSP430 */

#if   defined(SYSQ)
#include <msp430x14x.h> /* for MSP430F149 */
#elif defined(SYSR)
#include <msp430x14x.h> /* for MSP430F149 */
#elif defined(SYSS)
#include <msp430x14x.h> /* for MSP430F149 */
#elif defined(SYSX)
#endif

#define PORT						P1OUT
#define InitPORT()				    do { P1OUT  = 0x00; \
                                         P1DIR |= 0xFF; \
                                    } while (0)  /* P1 is all-output */ 

#define Init()                      do { WDTCTL = WDTPW + WDTHOLD;     /* Stop WDT */ \
                                         TACTL  = TASSEL1 + TACLR;     /* SMCLK, clear TAR */ \
                                         CCTL0  = CCIE;                /* CCR0 interrupt enabled */ \
                                         CCR0   = 10000; \
                                         TACTL |= MC1;                 /* Start Timer_A in continuous mode */ \
                                    } while (0)

/*															*/																
/* ====================== M68HC11 ========================= */
/*															*/																
#elif defined(SYST) /* ImageCraft ICC11 */

#if defined(USE_PORTC)
#define InitPORT()					do { PIOC &= 0b00001111; \
                                 		DDRC  = 0b11111111; \
                                 		PORTC = 0x00; \
                            		} while (0)
#else
#define InitPORT()					PORTB = 0x00
#endif

#if defined(USE_PORTC)
#define	PORT						PORTC
#else
#define PORT						PORTB
#endif

#define	Init()						do { PACTL &= 0b11111100; \
                                         PACTL |= 0b00000010; \
                                         TMSK2 |= 0b01000000; \
									} while (0)


/*															*/																
/* ======================= AVR ============================ */
/*															*/																
#elif defined(SYSV) /* ImageCraft ICCAVR */ \
   || defined(SYSY) /* AVR-GCC           */ 

#if   defined(SYSV)
#include <io8515v.h> /* for AT90S8515 */
#elif defined(SYSY)
#include <avr/signal.h>
#endif


#define PORT						PORTB 
#define InitPORT()					DDRB = 0xFF

#define Init()						do { TCCR1B = 0x00; /* Stop Timer1 */ \
										 TCNT1H = 0x00; /* Clear Timer1 */ \
										 OCR1AH = 0x00; /* Set Compare A to 39 */ \
										 OCR1AL = 0x26; /* ((4MHz/1024)/39) = 10ms (9.984ms) timer */ \
										 TIMSK  = 0x40; /* Compare A Interrupt enable */ \
										 TCCR1B = 0x0D; /* Start Timer1 with clk/1024 */ \
								    } while (0)


/*                                                          */                                                                
/* ===================== TMS320C28x ======================= */
/*                                                          */                                                                
#elif defined(SYSW) /* TI Code Composer Studio 'C2000 */

/* just define an imaginary port called PORTB and write     */
/*  to it ...                                               */
unsigned int PORTB;

/* Initialization of Timer2 is in InitTMR2() in vectors.asm.*/
extern void InitTMR2(void);

#define PORT						PORTB
#define InitPORT()				    

#define Init()                      do { InitTMR2();   \
                                    } while (0)


/*                                                          */                                                                
/* ===================== TMS320C24x ======================= */
/*                                                          */                                                                
#elif defined(SYSAA) /* TI Code Composer */
#include <f2407_c.h> /* for TMS320LF2407A */

/* Initialization of '2407 is in initialize.c. */
extern void InitLF2407(void);

#define Init()						do { InitLF2407();\
                                    } while (0)

/* set GPIO PORT B to all outputs and zero it in one op. 	*/
#define PORT						*PBDATDIR					
#define InitPORT()					do { PORT = 0xFF00; \
                                    } while (0)				


/*                                                          */                                                                
/* ====================== undefined ======================= */
/*                                                          */                                                                
#else                      
#error Undefined Salvo test system (SYS*). Definition required.


#endif
